#ifndef _DLC_H    /* Guard against multiple inclusion */
#define _DLC_H

#include <xc.h>
//ISR macros
#include <sys\attribs.h>

#define AUDIO_SAMPLE_RATE (38400L)

#define _XTAL_FREQ 40000000

//data for lighting control
//using pin 9 = RA2
#define TX_SET LATASET=_LATA_LATA2_MASK
#define TX_CLR LATACLR=_LATA_LATA2_MASK

#define LAMPS 64
unsigned char DLC_data[LAMPS+1]={0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};

unsigned char rampTime[LAMPS]={        //ramps for software use
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};

unsigned char rampSteps[LAMPS]={        //ramps for software use
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};
//pointer aliases into existing code
unsigned char* lamps=DLC_data+1;

int DLC_state=0;        //0=off, otherwise value is machine state
char DLC_run=0;         //boolean state
char DLC_seq_state=0;   //are we processing a sequence?
char WAV_state=0;       //0=off, 1=playing
unsigned long tmr=0;            //timer counter incremented by DLC ISR
unsigned long seqtmr=0;            //timer counter incremented by events in the sequence

char wav_bytes_per_sample=0;        //number of bytes per sample
char wav_signed=0;                  //is data signed?
char wav_left_offset=0;             //byte offset of left channel
char wav_right_offset=0;            //byte offset of right channel
long wav_sample_rate=0;             //samples per second
long wav_offset=0;                  //to manage sample dithering rate

#define BUFFERCOUNT 56
#define BUFFERSIZE 512
char wavBuffer[BUFFERCOUNT][BUFFERSIZE];               //heaps of RAM available
char seqBuffer[BUFFERCOUNT][BUFFERSIZE];                
int wavBufferBytes[BUFFERCOUNT];                       //number of bytes available to play
int seqBufferBytes[BUFFERCOUNT];
char wavBufferInUse=0;                                 //buffer being read
char seqBufferInUse=0;
int wavBufferPtr=0;                                     //pointer into buffer in use
int seqBufferPtr=0;

//for ramp/samples updates in ms
#define PACKET_TIMEOUT 20

void dlc_init(void);
long parse_word(unsigned char first, unsigned char second);//parse a data word and return duration
long parse_word_no_action(unsigned char first, unsigned char second); //returns 'time' in ms, no output
void checkRamps(long tm);          //process ramps as needed

const char sin64[64]={
    128,138,148,157,166,175,184,191,199,205,211,216,220,224,226,
    228,228,228,226,224,220,216,211,205,199,191,184,175,166,157,
    148,138,128,118,108,99,90,81,72,65,57,51,45,40,36,32,30,28,
    28,28,30,32,36,40,45,51,57,65,72,81,90,99,108,118};

#endif /* _DLC_H */
